#include <bits/stdc++.h>
using namespace std;

static long long choose2(long long k) {
    return k * (k - 1) / 2;
}

static int parity(long long v) {
    v %= 2;
    if (v < 0) v += 2;
    return (int)v; // 0 ili 1
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    unordered_map<long long, long long> diagSumCount;
    unordered_map<long long, long long> diagDiffCount;
    
    unordered_map<long long, long long> sameRowParityCount;
    unordered_map<long long, long long> sameColParityCount;

    diagSumCount.reserve(2LL * n);
    diagDiffCount.reserve(2LL * n);
    sameRowParityCount.reserve(2LL * n);
    sameColParityCount.reserve(2LL * n);

    for (int i = 0; i < n; i++) {
        long long x, y;
        cin >> x >> y;

        diagSumCount[x + y]++;
        diagDiffCount[x - y]++;

        long long rowKey = 2 * y + parity(x);
        long long colKey = 2 * x + parity(y);

        sameRowParityCount[rowKey]++;
        sameColParityCount[colKey]++;
    }

    long long diagPairs = 0;
    for (auto &e : diagSumCount)  diagPairs += choose2(e.second);
    for (auto &e : diagDiffCount) diagPairs += choose2(e.second);

    long long rowPairs = 0;
    for (auto &e : sameRowParityCount) rowPairs += choose2(e.second);

    long long colPairs = 0;
    for (auto &e : sameColParityCount) colPairs += choose2(e.second);

    long long answer = 2 * diagPairs + rowPairs + colPairs;
    cout << answer << "\n";
    return 0;
}